
<?php $__env->startSection('page_title', __('Create :x', ['x' => __('User')])); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/media-manager.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/user-list.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="user-add-container">
        <div class="card">
            <div class="card-header">
                <h5> <a href="<?php echo e(route('users.index')); ?>"><?php echo e(__('Users')); ?> </a>
                    >> <?php echo e(__('Create :x', ['x' => __('User')])); ?></h5>
            </div>
            <div class="card-block table-border-style">
                <div class="row form-tabs">
                    <form action="<?php echo e(route('users.store')); ?>" method="post" id="userAdd"
                        class="form-horizontal col-sm-12" enctype="multipart/form-data"
                        onsubmit="return passwordValidation()">
                        <?php echo csrf_field(); ?>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active text-uppercase font-bold" id="home-tab" data-bs-toggle="tab" href="#home"
                                    role="tab" aria-controls="home"
                                    aria-selected="true"><?php echo e(__(':x Information', ['x' => __('User')])); ?></a>
                            </li>
                        </ul>
                        <div class="col-sm-12 tab-content form-edit-con" id="myTabContent">
                            <div class="tab-pane fade show active form-con" id="home" role="tabpanel"
                                aria-labelledby="home-tab">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <div class="form-group row">
                                            <label for="name" class="control-label require ps-3"><?php echo e(__('Name')); ?>

                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="<?php echo e(__('Name')); ?>"
                                                    class="form-control form-width inputFieldDesign" id="name"
                                                    name="name" required minlength="3" value="<?php echo e(old('name')); ?>"
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                                    data-min-length="<?php echo e(__(':x should contain at least :y characters.', ['x' => __('Name'), 'y' => 3])); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="email"
                                                class="control-label require ps-3"><?php echo e(__('Email')); ?></label>
                                            <div class="col-sm-12">
                                                <input type="email"
                                                    class="form-control form-width inputFieldDesign bg-white" id="email"
                                                    name="email" value="<?php echo e(old('email')); ?>"
                                                    placeholder="<?php echo e(__('Email')); ?>" required
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                                    data-type-mismatch="<?php echo e(__('Enter a valid :x.', ['x' => strtolower(__('Email'))])); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="password"
                                                class="col-sm-2 control-label require"><?php echo e(__('Password')); ?></label>
                                            <div class="col-sm-12">
                                                <div>
                                                    <input type="password"
                                                    class="form-control password-validation form-width inputFieldDesign"
                                                    id="password" name="password" placeholder="<?php echo e(__('Password')); ?>"
                                                    value="<?php echo e(old('password')); ?>" required minlength="5"
                                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')"
                                                    data-min-length="<?php echo e(__(':x should contain at least :y characters.', ['x' => __('Password'), 'y' => 5])); ?>">
                                                </div>
                                                
                                                <span class="password-validation-error mt-1 d-block"></span>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="role_id"
                                                class="col-sm-2 control-label require"><?php echo e(__('Role')); ?></label>
                                            <div class="col-sm-12">
                                                <select class="form-control select2-hide-search inputFieldDesign"
                                                    name="role_ids[]" id="role_id">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($role->id); ?>"
                                                            <?php echo e(old('role_id') == $role->id ? 'selected' : ''); ?>>
                                                            <?php echo e($role->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="Status" class="control-label ps-3"><?php echo e(__('Status')); ?></label>
                                            <div class="col-sm-12">
                                                <select class="form-control select2-hide-search inputFieldDesign"
                                                    name="status" id="status">
                                                    <option value="Pending"
                                                        <?php echo e(old('status') == 'Pending' || preference('user_default_signup_status') == 'Pending' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Pending')); ?></option>
                                                    <option value="Active"
                                                        <?php echo e(old('status') == 'Active' || preference('user_default_signup_status') == 'Active' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Active')); ?></option>
                                                    <option value="Inactive"
                                                        <?php echo e(old('status') == 'Inactive' || preference('user_default_signup_status') == 'Inactive' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Inactive')); ?></option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-sm-2 control-label ps-3"><?php echo e(__('Picture')); ?></label>
                                            <div class="col-sm-12">
                                                <div class="custom-file position-relative" data-val="single"
                                                    id="image-status">
                                                    <input class="custom-file-input form-control d-none inputFieldDesign"
                                                        name="attachments" id="validatedCustomFile" accept="image/*">
                                                    <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                        for="validatedCustomFile"><?php echo e(__('Upload image')); ?></label>
                                                </div>
                                            </div>
                                            <div id="img-container">
                                                <!-- img will be shown here -->
                                            </div>
                                        </div>

                                        <div class="form-group m-0 my-md-3 d-felx mt-3">
                                            <label class="control-label "></label>
                                            <div>
                                                <div class="checkbox checkbox-warning checkbox-fill d-inline">
                                                    <input type="checkbox" class="form-control" name="send_mail"
                                                        id="checkbox-p-fill-1">
                                                    <label for="checkbox-p-fill-1"
                                                        class="cr"><?php echo e(__('Send email to the user')); ?></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex btn-align mt-3 flex-wrap">
                                <a href="<?php echo e(route('users.index')); ?>"
                                    class="btn custom-btn-cancel all-cancel-btn"><?php echo e(__('Cancel')); ?></a>
                                <button class="btn custom-btn-submit" type="submit" id="btnSubmit"><i
                                        class="comment_spinner spinner fa fa-spinner fa-spin custom-btn-small display_none"></i><span
                                        id="spinnerText"><?php echo e(__('Create')); ?></span></button>
                            </div>
                        </div>
                        <!-- Modal -->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('mediamanager::image.modal_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php
    $uppercase = $lowercase = $number = $symbol = $length = 0;
    if (env('PASSWORD_STRENGTH') != null && env('PASSWORD_STRENGTH') != '') {
        $length = filter_var(env('PASSWORD_STRENGTH'), FILTER_SANITIZE_NUMBER_INT);
        $conditions = explode('|', env('PASSWORD_STRENGTH'));
        $uppercase = in_array('UPPERCASE', $conditions);
        $lowercase = in_array('LOWERCASE', $conditions);
        $number = in_array('NUMBERS', $conditions);
        $symbol = in_array('SYMBOLS', $conditions);
    }
?>
<?php $__env->startSection('js'); ?>
    <script>
        'use strict';
        var uppercase = "<?php echo $uppercase; ?>";
        var lowercase = "<?php echo $lowercase; ?>";
        var number = "<?php echo $number; ?>";
        var symbol = "<?php echo $symbol; ?>";
        var length = "<?php echo $length; ?>";
        var currentUrl = "<?php echo url()->full(); ?>";
        var loginNeeded = "<?php echo session('loginRequired') ? 1 : 0; ?>";
    </script>
    <script src="<?php echo e(asset('public/dist/js/custom/user.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/resources/views/admin/users/create.blade.php ENDPATH**/ ?>