
<?php $__env->startSection('page_title', __('Pages')); ?>
<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12 list-container pages-container" id="coupon-list-container">
        <div class="card">
            <div class="card-header d-md-flex justify-content-between align-items-center">
                <h5><a href="<?php echo e(route('page.index')); ?>"><?php echo e(__('Page')); ?></a></h5>
                <div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array('Modules\CMS\Http\Controllers\CMSController@create', $prms)): ?>
                        <a href="<?php echo e(route('page.create')); ?>" class="btn btn-outline-primary custom-btn-small mb-0 me-0 mt-2 mt-md-0">
                            <span class="fa fa-plus"> &nbsp;</span><?php echo e(__('Add Page')); ?>

                        </a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
            <div class="card-body px-3">
                <div class="card-block pt-2 px-0">
                    <div class="col-sm-12 row m-0 p-0">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-12 col-xl-4 col-md-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <div class="card-title d-flex justify-content-between">
                                            <h5><?php echo e($page->name); ?>

                                            </h5>
                                            <span class="header-btn folding editable" data-id="<?php echo e($page->id); ?>"
                                                data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Quick edit')); ?>"
                                                data-original-title="<?php echo e(__('Quick edit')); ?>">
                                                <i class="feather icon-edit-2"></i>
                                            </span>
                                        </div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($page->status == 'Active'): ?>
                                            <span class="badge badge-info"><?php echo e(__($page->status)); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-danger"><?php echo e(__($page->status)); ?></span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <p class="card-text">
                                        <dl class="dl-horizontal row">
                                            <dt class="col-12"><u><?php echo e(__('Meta Informations')); ?>:</u></dt>
                                            <dt class="col-sm-4"><?php echo e(__('Title')); ?>:</dt>
                                            <dd class="col-sm-8"><?php echo e(formatString($page->meta_title, 40)); ?></dd>
                                            <dt class="col-sm-4"><?php echo e(__('Description')); ?>:</dt>
                                            <dd class="col-sm-8"><?php echo e(formatString($page->meta_description)); ?></dd>
                                        </dl>
                                        </p>
                                        <div class="header-btns-lg">
                                            <a href="<?php echo e(route('pb.edit', ['slug' => $page->slug])); ?>" target="_blank"
                                                class="header-btn folding btn-primary"
                                                data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Edit with pagebuilder')); ?>"
                                                data-original-title="<?php echo e(__('Edit with pagebuilder')); ?>">
                                                <i class="feather icon-grid me-2"></i><?php echo e(__('Builder')); ?>

                                            </a>
                                            <a href="<?php echo e(route('page.edit', $page->slug)); ?>"
                                                class="header-btn folding btn-primary"
                                                data-toggle="tooltip" data-placement="top" title="<?php echo e(__('Edit page')); ?>"
                                                data-original-title="<?php echo e(__('Edit page')); ?>">
                                                <i class="feather icon-edit me-2"></i><?php echo e(__('Edit')); ?>

                                            </a>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($page->status == 'Active'): ?>
                                                <a href="<?php echo e(route('site.page', $page->slug)); ?>"
                                                    class="header-btn folding btn-primary" target="_blank"
                                                    data-toggle="tooltip" data-placement="top"
                                                    title="<?php echo e(__('View page')); ?>"
                                                    data-original-title="<?php echo e(__('View page')); ?>">
                                                    <i class="feather icon-eye me-2"></i><?php echo e(__('Preview')); ?>

                                                </a>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <span class="header-btn delete-button" data-toggle="tooltip"
                                                data-id="<?php echo e($page->id); ?>" data-bs-toggle="modal" data-placement="top"
                                                title="<?php echo e(__('Delete page')); ?>"
                                                data-original-title="<?php echo e(__('Delete page')); ?>">
                                                <i class="feather icon-trash-2 me-2"></i><?php echo e(__('Delete')); ?>

                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-sm-12 m-0 p-0 text-center">
                                <?php echo e(__('No pages available.')); ?>

                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php echo $__env->make('cms::pieces.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div id="updatePage" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="updatePageLabel"
        aria-hidden="true">
        <form method="post" action="<?php echo e(route('page.update', ['id' => '__id__'])); ?>" class="silent-form" id="updatePageFrom">
            <?php echo csrf_field(); ?>
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="confirmDeleteLabel"><?php echo e(__('Update page')); ?></h5>
                        <a type="button" class="close h5" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </a>
                    </div>
                    <div class="modal-body">
                        <div class="form-group row">
                            <label class="col-sm-3" for="pageName"><?php echo e(__('Name')); ?></label>
                            <div class="col-sm-9">

                                <input type="text" class="form-control inputFieldDesign" required name="name" id="pageName"
                                    placeholder="<?php echo e(__('Name')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3" for="PageSlug"><?php echo e(__('Slug')); ?></label>
                            <div class="col-sm-9">
                                <input type="text" name="slug" class="form-control inputFieldDesign" required id="pageSlug"
                                    placeholder="<?php echo e(__('Slug')); ?>">
                            </div>
                        </div>
                        <div class="form-group row mb-0">
                            <label class="col-sm-3 mt-2" for="Pagelug"><?php echo e(__('Status')); ?></label>
                            <div class="col-sm-9">
                                <input name="status" type="hidden" value="Inactive">

                                <div class="switch switch-bg d-inline">
                                    <input name="status" type="checkbox" id="switch-1" value="Active" checked="">
                                    <label for="switch-1" class="cr"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="py-2 custom-btn-cancel"
                            data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit"
                            class="btn py-2 custom-btn-submit has-spinner-loader"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('Modules/CMS/Resources/assets/css/draganddrop.min.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
    <script>
        let tempId;
        let pages = <?php echo json_encode($pages->toArray()); ?>;
        const updateForm = $('#updatePageFrom');
        let updatePageUrl = "<?php echo e(route('page.update', ['id' => '__id__'])); ?>";
        let deletePageUrl = "<?php echo e(route('page.delete', ['id' => '__id__'])); ?>";
    </script>
    <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/app.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/index.blade.php ENDPATH**/ ?>