<?php
    $component = isset($component) ? $component : null;
    $allPlans = \Modules\Subscription\Services\PackageSubscriptionService::getActivePlans();
    $allCredits =  \Modules\Subscription\Services\CreditService::getActiveCredits();
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Overline')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign crequired" maxlength="70" name="overline"
                       value="<?php echo e($component ? $component->overline : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign crequired" name="heading"
                       value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Body')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="body" required> <?php echo e($component ? trim($component->body) : ''); ?></textarea>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Button')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Subscription Name')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control inputFieldDesign" name="plan_btn_name" maxlength="25"
                                            value="<?php echo e($component ? $component->plan_btn_name : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Credit Name')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control inputFieldDesign" name="credit_btn_name" maxlength="25"
                                            value="<?php echo e($component ? $component->credit_btn_name : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row  d-none">
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_light"
                                            value="<?php echo e($component ? $component->btn_color_light : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_dark"
                                            value="<?php echo e($component ? $component->btn_color_dark : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light"
                                            value="<?php echo e($component ? $component->btn_text_color_light : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark"
                                            value="<?php echo e($component ? $component->btn_text_color_dark : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>

            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Subscription Plan')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Plan Type')); ?></label>
                                <select type="text"class="form-control crequired select3 plan_type" name="plan_type">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \Modules\CMS\Service\Homepage::planOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($component && $component->plan_type == $key ? 'selected' : ''); ?>

                                            value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 plan-cats latestPlans <?php echo e(empty($component->plan_type) ||  $component->plan_type == 'latestPlans' ? '' : 'd-none'); ?>">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('No. of plans to show')); ?></label>
                                <div>
                                    <input type="number" min="1" max="30" class="form-control crequired inputFieldDesign plan_limit" name="plan_limit"
                                        <?php echo e(empty($component->plan_type) ||  $component->plan_type == 'latestPlans' ? 'required' : ''); ?>

                                       value="<?php echo e($component ? $component->plan_limit : 3); ?>">
                                </div>
                                <div class="d-flex mt-2">
                                    <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                                    <small
                                        class="mt-1 ltr:ms-2 rtl:me-2"><?php echo e(__('Default plan number is 3')); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row plan-cats selectedPlans <?php echo e($component && $component->plan_type == 'selectedPlans' ? '' : 'd-none'); ?>">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Plans')); ?></label>
                                <select type="text" class="form-control select2 sl_common_bx select_plan" <?php echo e($component && $component->plan_type == 'selectedPlans' ? 'required' : ''); ?> name="plans[]" multiple>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && is_array($component->plans)): ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $component->plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($allPlans[$selected])): ?>
                                                <Option selected value="<?php echo e($selected); ?>"><?php echo e($allPlans[$selected]); ?></Option>
                                                <?php
                                                    unset($allPlans[$selected]);
                                                ?>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $allPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <Option value="<?php echo e($key); ?>"><?php echo e($value); ?></Option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="plan_text_color_light"
                                            value="<?php echo e($component ? $component->plan_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="plan_text_color_dark"
                                            value="<?php echo e($component ? $component->plan_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-4 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="plan_btn_color_light"
                                                    value="<?php echo e($component ? $component->plan_btn_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="plan_btn_color_dark"
                                                    value="<?php echo e($component ? $component->plan_btn_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="plan_btn_text_color_light"
                                                    value="<?php echo e($component ? $component->plan_btn_text_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="plan_btn_text_color_dark"
                                                    value="<?php echo e($component ? $component->plan_btn_text_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Credit')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Credit Type')); ?></label>
                                <select type="text"class="form-control crequired select3 credit_type" name="credit_type">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \Modules\CMS\Service\Homepage::creditOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($component && $component->credit_type == $key ? 'selected' : ''); ?>

                                            value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 credit-cats latestCredits <?php echo e(empty($component->credit_type) || $component->credit_type == 'latestCredits' ? '' : 'd-none'); ?>">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"> <?php echo e(__('No. of credits to show')); ?></label>
                                <div>
                                    <input type="number" min="1" max="30" class="form-control crequired inputFieldDesign credit_limit" name="credit_limit"
                                        <?php echo e(empty($component->credit_type) || $component->credit_type == 'latestCredits' ? 'required' : ''); ?>

                                       value="<?php echo e($component ? $component->credit_limit : 3); ?>">
                                </div>
                                <div class="d-flex mt-2">
                                    <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                                    <small
                                        class="mt-1 ltr:ms-2 rtl:me-2"><?php echo e(__('Default credit plan number is 3')); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row credit-cats selectedCredits <?php echo e($component && $component->credit_type == 'selectedCredits' ? '' : 'd-none'); ?>">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Credits')); ?></label>
                                <select type="text" class="form-control select2 sl_common_bx select_credit" <?php echo e($component && $component->credit_type == 'selectedCredits' ? 'required' : ''); ?> name="credits[]" multiple>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && is_array($component->credits)): ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $component->credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($allCredits[$selected])): ?>
                                                <Option selected value="<?php echo e($selected); ?>"><?php echo e($allCredits[$selected]); ?></Option>
                                                <?php unset($allCredits[$selected]); ?>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $allCredits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <Option value="<?php echo e($key); ?>"><?php echo e($value); ?></Option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Heading Text Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_text_color_light_head"
                                                    value="<?php echo e($component ? $component->credit_text_color_light_head : ''); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Heading Text Color (Dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_text_color_dark_head"
                                                    value="<?php echo e($component ? $component->credit_text_color_dark_head : ''); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_text_color_light"
                                                    value="<?php echo e($component ? $component->credit_text_color_light : ''); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_text_color_dark"
                                                    value="<?php echo e($component ? $component->credit_text_color_dark : ''); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_btn_color_light"
                                                    value="<?php echo e($component ? $component->credit_btn_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_btn_color_dark"
                                                    value="<?php echo e($component ? $component->credit_btn_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_btn_text_color_light"
                                                    value="<?php echo e($component ? $component->credit_btn_text_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="credit_btn_text_color_dark"
                                                    value="<?php echo e($component ? $component->credit_btn_text_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['margin']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>
            
            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>

<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/subscription-plan-template-v1.blade.php ENDPATH**/ ?>