<?php
    $component = isset($component) ? $component : null;
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" novalidate data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Overline')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign crequired" maxlength="70" name="overline" id="overline"
                       value="<?php echo e($component ? $component->overline : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign crequired" name="heading" id="heading"
                       value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>

            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Body')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="body" id="body" required> <?php echo e($component ? trim($component->body) : ''); ?></textarea>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('First Block')); ?></dt>
                        </label>
                        <input type="hidden" name="first_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="first_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->first_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light"
                                        value="<?php echo e($component ? $component->bg_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark"
                                        value="<?php echo e($component ? $component->bg_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="first_block_text_color_light"
                                        value="<?php echo e($component ? $component->first_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="first_block_text_color_dark"
                                        value="<?php echo e($component ? $component->first_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width"
                                            value="<?php echo e($component && $component->border_width ? $component->border_width : ''); ?>" placeholder="1"
                                            class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style"
                                        value="<?php echo e($component && $component->border_style ? $component->border_style : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color" data-control="hue"
                                        value="<?php echo e($component && $component->border_color ? $component->border_color : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Heading')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign crequired" name="block1_heading" id="heading"
                               value="<?php echo e($component ? $component->block1_heading : ''); ?>">
                        </div>
                    </div>    
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('First Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block1_body" required> <?php echo e($component ? trim($component->block1_body) : ''); ?></textarea>
                        </div>
                    </div>

                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Second Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block1_second_body" required> <?php echo e($component ? trim($component->block1_second_body) : ''); ?></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="image_light_mode" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="image_light_mode"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image_light_mode): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->image_light_mode)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="image_light_mode"
                                                        value="<?php echo e($component->image_light_mode); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Second Block')); ?></dt>
                        </label>
                        <input type="hidden" name="second_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="second_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->second_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light2"
                                        value="<?php echo e($component ? $component->bg_color_light2 : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark2"
                                        value="<?php echo e($component ? $component->bg_color_dark2 : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="second_block_text_color_light"
                                        value="<?php echo e($component ? $component->second_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="second_block_text_color_dark"
                                        value="<?php echo e($component ? $component->second_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width2"
                                            value="<?php echo e($component && $component->border_width2 ? $component->border_width2 : ''); ?>" placeholder="1"
                                            class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style2"
                                        value="<?php echo e($component && $component->border_style2 ? $component->border_style2 : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color2" data-control="hue"
                                        value="<?php echo e($component && $component->border_color2 ? $component->border_color2 : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Heading')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign crequired" name="block2_heading"
                               value="<?php echo e($component ? $component->block2_heading : ''); ?>">
                        </div>
                    </div>    
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block2_body" required> <?php echo e($component ? trim($component->block2_body) : ''); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Third Block')); ?></dt>
                        </label>
                        <input type="hidden" name="third_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="third_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->third_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light3"
                                        value="<?php echo e($component ? $component->bg_color_light3 : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark3"
                                        value="<?php echo e($component ? $component->bg_color_dark3 : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="third_block_text_color_light"
                                        value="<?php echo e($component ? $component->third_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="third_block_text_color_dark"
                                        value="<?php echo e($component ? $component->third_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width3"
                                            value="<?php echo e($component && $component->border_width3 ? $component->border_width3 : ''); ?>" placeholder="1"
                                            class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style3"
                                        value="<?php echo e($component && $component->border_style3 ? $component->border_style3 : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color3" data-control="hue"
                                        value="<?php echo e($component && $component->border_color3 ? $component->border_color3 : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="image_light_mode3" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="image_light_mode3"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image_light_mode3): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->image_light_mode3)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="image_light_mode3"
                                                        value="<?php echo e($component->image_light_mode3); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Heading')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign crequired" name="block3_heading"
                               value="<?php echo e($component ? $component->block3_heading : ''); ?>">
                        </div>
                    </div>    
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('First Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block3_body" required> <?php echo e($component ? trim($component->block3_body) : ''); ?></textarea>
                        </div>
                    </div>

                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Second Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block3_second_body" required> <?php echo e($component ? trim($component->block3_second_body) : ''); ?></textarea>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign" maxlength="40"
                                                value="<?php echo e($component ? $component->btn_name : ''); ?>" name="btn_name">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign"
                                                value="<?php echo e($component ? $component->btn_link : ''); ?>" name="btn_link">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Light Mode)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light"
                                                    value="<?php echo e($component ? $component->btn_text_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Dark Mode)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark"
                                                    value="<?php echo e($component ? $component->btn_text_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['padding-vertical']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>
            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>


<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/ai-template-v1.blade.php ENDPATH**/ ?>