
<?php $__env->startSection('page_title', __('Homepage Builder')); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('mediamanager::image.modal_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php
        $homeService = new \Modules\CMS\Service\HomepageService();
    ?>
    <div class="col-md-12 no-print notification-msg-bar smoothly-hide">
        <div class="noti-alert pad">
            <div class="alert bg-dark text-light m-0 text-center">
                <span class="notification-msg"></span>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <div class="col-sm-12 list-container">
        <div class="card">
            <div class="card-header d-md-flex justify-content-between align-items-center">
                <div>
                    <h5>
                        <a href="<?php echo e(route('page.home')); ?>"><?php echo e(__('Homepages')); ?></a>
                        >>
                        <a href="javascript:void();"><?php echo e($page->name); ?></a>

                    </h5>
                </div>
                <div class="d-flex justify-content-end align-items-center">
                    <div class="form-group mb-0 d-none">
                        <button class="btn btn-success btn-sm has-spinner-loader mb-0" id="update_page" type="submit"><i
                                class="feather icon-save ltr:me-1 rtl:ms-1"></i><?php echo e(__('Save')); ?>

                        </button>
                    </div>
                    <div class="form-group d-flex mb-0">
                        <a class="btn btn-sm btn-info mb-0" href="<?php echo e(route('site.page', $page->slug)); ?>" target="_blank"><i
                                class="feather icon-eye ltr:me-1 rtl:ms-1"></i><?php echo e(__('Preview')); ?></a>
                    </div>
                    <div class="form-group d-flex mb-0">
                        <button class="btn btn-sm btn-primary mb-0 ltr:me-0 rtl:ms-0" id="add-new-widget"><i
                                class="feather icon-plus ltr:me-1 rtl:ms-1"></i><?php echo e(__('Add Section')); ?></button>
                    </div>
                </div>
        </div>
            <div class="card-body px-4">
                <div class="card-block pt-2 px-0">
                    <ul id="sortable" class="selector">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $page->components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $component): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="ui-state-default" data-id="<?php echo e($level = uniqid('level_')); ?>">
                                <div class="component-header">
                                    <i class="feather feather icon-move"></i>
                                    <div class="header-text">
                                        <h5 class="header-title">
                                            <?php echo e($component->title ?? optional($component->layout)->name); ?>

                                        </h5>
                                        <?php echo $__env->make('cms::pieces.header-badges', [
                                            'layout' => $component->layout,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="header-btns">
                                        <span class="header-btn delete-button" data-bs-toggle="modal"
                                            data-bs-target="#confirmDelete"
                                            data-component="<?php echo e($component->title ?? optional($component->layout)->name); ?>"
                                            data-component-id="<?php echo e($component->id); ?>">
                                            <i class="feather icon-trash-2"></i>
                                        </span>
                                        <span class="header-btn folding closed btn-primary">
                                            <i class="feather icon-chevron-up"></i>
                                        </span>
                                    </div>

                                </div>
                                <?php echo $__env->make('cms::edit.' . $component->layout->file, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div>
            <form action="#" id="internal_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="data" id="data">
            </form>
        </div>
    </div>
    <div id="confirmDelete" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmDeleteLabel"><?php echo e(__('Delete Section')); ?></h5>
                    <a type="button" class="close h5" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </a>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('Are you sure to delete this section?')); ?></p>
                    <p><strong><?php echo e(__('Section')); ?>:</strong><span class="ml-" id="component-title"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="py-2 custom-btn-cancel"
                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="button" id="confirmDeleteSubmitBtn" data-task="1"
                        class="btn py-2 custom-btn-submit delete-section-btn"><?php echo e(__('Delete')); ?>

                    </button>
                    <span class="ajax-loading"></span>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('Modules/CMS/Resources/assets/css/draganddrop.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('Modules/CMS/Resources/assets/css/style.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/plugins/lightbox/js/lightbox.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.js')); ?>"></script>

    <script>
        let selectorData = <?php echo json_encode($layouts, 15, 512) ?>;
        const selector = `<?php echo $selector; ?>`;
        const sortable = $('#sortable');
        let request;
        let __page = <?php echo e($page->id); ?>;
        const __gridDeleteUrl = `<?php echo e(route('builder.delete', ['id' => $page->id])); ?>`;
        const __savePageUrl = "<?php echo e(route('builder.updateAll', ['id' => $page->id])); ?>";
        let popupNotification;
        let deletingSectionId;
        let deletingSection;
        const ajaxResourceUrl = `<?php echo e(route('ajaxResourceSelect')); ?>`;
        const queryOperations = <?php echo json_encode($queryOperations, 15, 512) ?>;
    </script>

    <script src="<?php echo e(asset('public/dist/js/xss.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/builder.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/query.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/builder.blade.php ENDPATH**/ ?>