<?php
    $component = isset($component) ? $component : null;

?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" novalidate data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Background')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <div class="row">
                        <label class="col-md-12 control-label"><?php echo e(__('Type')); ?></label>
                        <div class="col-sm-12">
                            <select type="text"class="form-control crequired select3" name="background_type"
                            id="background_type">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \Modules\CMS\Service\Homepage::backgroundOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($component && $component->background_type == $key ? 'selected' : ''); ?>

                                        value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="row background-image-cats <?php echo e((empty($component->background_type) || $component->background_type == 'backgroundImage') ? '' : 'd-none'); ?>">
                        <?php $rand = uniqid(); ?>
                        <div class="col-md-6">
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="bg_image_light" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="bg_image_light"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->bg_image_light): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->bg_image_light)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="bg_image_light"
                                                        value="<?php echo e($component->bg_image_light); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row form-parent parent-class">
                                <?php $rand = uniqid(); ?>
                                <label class="col-sm-12 control-label"><?php echo e(__('Image (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="bg_image_dark" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="bg_image_dark"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->bg_image_dark): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->bg_image_dark)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="bg_image_dark"
                                                        value="<?php echo e($component->bg_image_dark); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row background-image-cats <?php echo e((empty($component->background_type) || $component->background_type == 'backgroundImage') ? '' : 'd-none'); ?>">
                        <?php $rand = uniqid(); ?>
                        <div class="col-md-6">
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Mob Image (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="mob_bg_image_light" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="mob_bg_image_light"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->mob_bg_image_light): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->mob_bg_image_light)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="mob_bg_image_light"
                                                        value="<?php echo e($component->mob_bg_image_light); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row form-parent parent-class">
                                <?php $rand = uniqid(); ?>
                                <label class="col-sm-12 control-label"><?php echo e(__('Mob Image (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="mob_bg_image_dark" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="mob_bg_image_dark"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->mob_bg_image_dark): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->mob_bg_image_dark)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="mob_bg_image_dark"
                                                        value="<?php echo e($component->mob_bg_image_dark); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row background-color-cats <?php echo e($component && $component->background_type == 'backgroundColor' ? '' : 'd-none'); ?>">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light"
                                        value="<?php echo e($component ? $component->bg_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark"
                                        value="<?php echo e($component ? $component->bg_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Overline')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign crequired" maxlength="70" name="overline"
                       value="<?php echo e($component ? $component->overline : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign crequired" name="heading"
                       value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>

            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Body')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="body" required> <?php echo e($component ? trim($component->body) : ''); ?></textarea>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Feature Highlights')); ?></dt>
                    </label>
                </div>
                <div class="col-md-8">
                    <div class="accordion outline-accordion <?php echo e($accordId = uniqid('accord_')); ?>" id="accordionExample">
                        <?php
                            $outlines = $component && is_array($component->outline) ? $component->outline : [];
                            $totalOutlines = count($outlines);
                        ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $outlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <?php $outline = miniCollection($outline); ?>

                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Hightlight')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($loop->last): ?>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($totalOutlines > 1): ?>
                                                        <span class="accordion-row-action remove-row-btn"
                                                            data-parent="<?php echo e($accordId); ?>"
                                                            data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                class="feather icon-minus"></i></span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <span class="accordion-row-action add-row-btn"
                                                        data-parent="<?php echo e($accordId); ?>"
                                                        data-index="<?php echo e($loop->index + 1); ?>"><i
                                                            class="feather icon-plus"></i></span>
                                                <?php else: ?>
                                                    <span class="accordion-row-action remove-row-btn"
                                                        data-index="<?php echo e($loop->index + 1); ?>"
                                                        data-parent="<?php echo e($accordId); ?>"><i
                                                            class="feather icon-minus"></i></span>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                    aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Title')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign"
                                                value="<?php echo $outline['title']; ?>" name="outline[<?php echo e($loop->index); ?>][title]">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Hightlight')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <span class="accordion-row-action add-row-btn"
                                                    data-parent="<?php echo e($accordId); ?>" data-index="1"><i
                                                        class="feather icon-plus"></i></span>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                    aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <div class="form-group row">
                                                <label class="col-sm-12 control-label"><?php echo e(__('Title')); ?></label>
                                                <div class="col-sm-12">
                                                    <input type="text" class="form-control inputFieldDesign"
                                                        name="outline[0][title]">
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Feature Sliders')); ?></dt>
                        </label>
                        <input type="hidden" name="feature_slider_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="feature_slider_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->feature_slider_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="accordion feature-slider-accordion <?php echo e($accordId = uniqid('accord_')); ?>" id="accordionExample">
                        <?php
                            $feature_sliders = $component && is_array($component->feature_slider) ? $component->feature_slider : [];
                            $totalFeatureSliders = count($feature_sliders);
                        ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $feature_sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <?php $slider = miniCollection($slider); ?>

                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Slider')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($loop->last): ?>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($totalFeatureSliders > 1): ?>
                                                        <span class="accordion-row-action remove-row-btn"
                                                            data-parent="<?php echo e($accordId); ?>"
                                                            data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                class="feather icon-minus"></i></span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <span class="accordion-row-action add-row-btn"
                                                        data-parent="<?php echo e($accordId); ?>"
                                                        data-index="<?php echo e($loop->index + 1); ?>"><i
                                                            class="feather icon-plus"></i></span>
                                                <?php else: ?>
                                                    <span class="accordion-row-action remove-row-btn"
                                                        data-index="<?php echo e($loop->index + 1); ?>"
                                                        data-parent="<?php echo e($accordId); ?>"><i
                                                            class="feather icon-minus"></i></span>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                    aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Image')); ?></label>
                                        <?php $rand = uniqid(); ?>
                                        <div class="col-md-12">
                                            <div class="custom-file media-manager"
                                                data-name="feature_slider[<?php echo e($loop->index); ?>][image]"
                                                data-val="single" id="image-status">
                                                <input class="custom-file-input form-control d-none"
                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                            </div>

                                            <div class="d-flex mt-2">
                                                <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                                                <small
                                                    class="mt-1 ltr:ms-2 rtl:me-2 ps-1"><?php echo e(__('For better resolution and superior quality, it is recommended to use SVG format.')); ?></small>
                                            </div>
                                            
                                            <div class="preview-image">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($slider['image']): ?>
                                                    <div class="d-flex flex-wrap mt-2">
                                                        <div
                                                            class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                            <div
                                                                class="position-absolute rounded-circle text-center img-remove-icon">
                                                                <i class="fa fa-times"></i>
                                                            </div>
                                                            <img class="upl-img" class="p-1"
                                                                src="<?php echo e(pathToUrl($slider['image'])); ?>"
                                                                alt="<?php echo e(__('Image')); ?>">
                                                            <input type="hidden"
                                                                name="feature_slider[<?php echo e($loop->index); ?>][image]"
                                                                id="validatedCustomFile"
                                                                value="<?php echo e($slider['image']); ?>">
                                                        </div>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Slider')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <span class="accordion-row-action add-row-btn"
                                                    data-parent="<?php echo e($accordId); ?>" data-index="1"><i
                                                        class="feather icon-plus"></i></span>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class" aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Image')); ?></label>
                                        <?php $rand = uniqid(); ?>
                                        <div class="col-md-12">
                                            <div class="custom-file media-manager"
                                                data-name="feature_slider[0][image]" data-val="single"
                                                id="image-status">
                                                <input class="custom-file-input form-control d-none"
                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                            </div>
                                            <div class="preview-image"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Default Sliders')); ?></dt>
                        </label>
                        <input type="hidden" name="default_slider_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="default_slider_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->default_slider_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="accordion feature-default-accordion <?php echo e($accordId = uniqid('accord_')); ?>" id="accordionExample">
                        <?php
                            $default_sliders = $component && is_array($component->default_slider) ? $component->default_slider : [];
                            $totalDefaultSliders = count($default_sliders);
                        ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $default_sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $defaultSlider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <?php $defaultSlider = miniCollection($defaultSlider); ?>

                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Slider')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($loop->last): ?>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($totalFeatureSliders > 1): ?>
                                                        <span class="accordion-row-action remove-row-btn"
                                                            data-parent="<?php echo e($accordId); ?>"
                                                            data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                class="feather icon-minus"></i></span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <span class="accordion-row-action add-row-btn"
                                                        data-parent="<?php echo e($accordId); ?>"
                                                        data-index="<?php echo e($loop->index + 1); ?>"><i
                                                            class="feather icon-plus"></i></span>
                                                <?php else: ?>
                                                    <span class="accordion-row-action remove-row-btn"
                                                        data-index="<?php echo e($loop->index + 1); ?>"
                                                        data-parent="<?php echo e($accordId); ?>"><i
                                                            class="feather icon-minus"></i></span>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                    aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Image')); ?></label>
                                        <?php $rand = uniqid(); ?>
                                        <div class="col-md-12">
                                            <div class="custom-file media-manager"
                                                data-name="default_slider[<?php echo e($loop->index); ?>][image]"
                                                data-val="single" id="image-status">
                                                <input class="custom-file-input form-control d-none"
                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                            </div>

                                            <div class="d-flex mt-2">
                                                <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                                                <small
                                                    class="mt-1 ltr:ms-2 rtl:me-2 ps-1"><?php echo e(__('For better resolution and superior quality, it is recommended to use SVG format.')); ?></small>
                                            </div>
                                            
                                            <div class="preview-image">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($defaultSlider['image']): ?>
                                                    <div class="d-flex flex-wrap mt-2">
                                                        <div
                                                            class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                            <div
                                                                class="position-absolute rounded-circle text-center img-remove-icon">
                                                                <i class="fa fa-times"></i>
                                                            </div>
                                                            <img class="upl-img" class="p-1"
                                                                src="<?php echo e(pathToUrl($defaultSlider['image'])); ?>"
                                                                alt="<?php echo e(__('Image')); ?>">
                                                            <input type="hidden"
                                                                name="default_slider[<?php echo e($loop->index); ?>][image]"
                                                                id="validatedCustomFile"
                                                                value="<?php echo e($defaultSlider['image']); ?>">
                                                        </div>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Slider')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <span class="accordion-row-action add-row-btn"
                                                    data-parent="<?php echo e($accordId); ?>" data-index="1"><i
                                                        class="feather icon-plus"></i></span>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class" aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Image')); ?></label>
                                        <?php $rand = uniqid(); ?>
                                        <div class="col-md-12">
                                            <div class="custom-file media-manager"
                                                data-name="default_slider[0][image]" data-val="single"
                                                id="image-status">
                                                <input class="custom-file-input form-control d-none"
                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                            </div>
                                            <div class="preview-image"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
           
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('First Button')); ?></dt>
                        </label>
                        <input type="hidden" name="first_button" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="first_button"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->first_button == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign" maxlength="40"
                                        value="<?php echo e($component ? $component->btn_name1 : ''); ?>" name="btn_name1">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign"
                                        value="<?php echo e($component ? $component->btn_link1 : ''); ?>" name="btn_link1">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_light1"
                                            value="<?php echo e($component ? $component->btn_color_light1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_dark1"
                                            value="<?php echo e($component ? $component->btn_color_dark1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light1"
                                            value="<?php echo e($component ? $component->btn_text_color_light1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark1"
                                            value="<?php echo e($component ? $component->btn_text_color_dark1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Second Button')); ?></dt>
                        </label>
                        <input type="hidden" name="second_button" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="second_button"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->second_button == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign" maxlength="40"
                                        value="<?php echo e($component ? $component->btn_name2 : ''); ?>" name="btn_name2">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign"
                                        value="<?php echo e($component ? $component->btn_link2 : ''); ?>" name="btn_link2">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_light2"
                                            value="<?php echo e($component ? $component->btn_color_light2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_dark2"
                                            value="<?php echo e($component ? $component->btn_color_dark2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light2"
                                            value="<?php echo e($component ? $component->btn_text_color_light2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark2"
                                            value="<?php echo e($component ? $component->btn_text_color_dark2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width2"
                                            value="<?php echo e($component && $component->border_width2 ? $component->border_width2 : ''); ?>"
                                            placeholder="1" class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style2"
                                        value="<?php echo e($component && $component->border_style2 ? $component->border_style2 : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color2" data-control="hue"
                                        value="<?php echo e($component && $component->border_color2 ? $component->border_color2 : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['margin']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>
            
            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>


<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/image-generator-template-v1.blade.php ENDPATH**/ ?>