<header>
    <div class="fixed top-0 right-0 left-0 w-full font-Figtree z-[99]">
        <nav
            class="flex h-[56px] items-center justify-between bg-color-2C transition-all duration-500 ease-in-out dark:bg-[#141414]">
            <div class="w-full h-[56px] flex items-center justify-between md:mx-5 gap-3">

                <div class="flex items-center justify-center">
                    <div class="w-[66px] h-[56px] mr-4 bg-[#464444] flex items-center justify-center md:hidden">
                        <svg class="collapse-icon pointer" width="26" height="26" viewBox="0 0 26 26" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M4 13H22M4 7H22M4 19H16" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round"></path>
                        </svg>
                    </div>

                    <a href="<?php echo e(route('frontend.index')); ?>" class="b-brand">
                        <?php
                            $logo = App\Models\Preference::getLogo('company_logo');
                        ?>
                        <img class="w-[104px] sm:w-[175px] h-7 sm:h-[42px] object-contain" width="104" height="28" src="<?php echo e($logo); ?>" alt="<?php echo e(trimWords(preference('company_name'), 17)); ?>">
                    </a>
                </div>

                
                <?php if ($__env->exists('affiliate::layouts.includes.customer_panel_header')) echo $__env->make('affiliate::layouts.includes.customer_panel_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="flex-1">
                    <div id="dropdowns-header" class="md:relative absolute top-1 md:top-0 right-[67px] md:right-1 flex justify-end items-center lg:gap-5 gap-3">
                        <div>
                            <?php
                                $flag = config('app.locale');
                                $languages = \App\Models\Language::getAll()->where('status', 'Active');
                            ?>
                            
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($languages->isNotEmpty()): ?>
                            <div class="cursor-pointer mt-3 md:mt-0 relative">
                                <a class="text-white text-16 cursor-pointer font-normal language-dropdown-click font-Figtree flex text-center gap-2 items-center justify-center">
                                    <img class="rounded-full cursor-pointer h-[18px] w-[18px] bg-white" src="<?php echo e(url("public/datta-able/fonts/flag/flags/4x3/" . getSVGFlag($flag) . ".svg")); ?>"
                                    alt="<?php echo e(__('Image')); ?>">
                                    <p> <?php echo e(ucFirst($flag)); ?> </p>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M2.64645 4.64605C2.45118 4.84131 2.45118 5.15789 2.64645 5.35316L5.64645 8.35316C5.84171 8.54842 6.15829 8.54842 6.35355 8.35316L9.35355 5.35316C9.54882 5.15789 9.54882 4.84131 9.35355 4.64605C9.15829 4.45079 8.84171 4.45079 8.64645 4.64605L6 7.2925L3.35355 4.64605C3.15829 4.45079 2.84171 4.45079 2.64645 4.64605Z" fill="white"/>
                                    </svg>
                                </a>
                                <div
                                    class="hidden origin-top-right md:top-9 py-2 top-7 absolute md:right-0 mx-auto md:mt-0 mt-2 w-[201px] border border-color-89 dark:border-color-47 rounded-lg bg-white dark:bg-color-29 z-50 language-drop-down dropdown-shadow language-dropdown max-h-[210px] overflow-auto sidebar-scrollbar">
                                    <div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a data-short-name="<?php echo e($language->short_name); ?>" class="lang-change flex justify-start items-center gap-1.5 text-14 font-medium text-color-14 dark:text-white font-Figtree px-[15px] py-2 hover:bg-color-F6 dark:hover:bg-[#3A3A39]">
                                                <img class="rounded-full cursor-pointer h-[18px] w-[18px] bg-white" src="<?php echo e(url("public/datta-able/fonts/flag/flags/4x3/" . getSVGFlag($language->short_name) . ".svg")); ?>"
                                                alt="<?php echo e(__('Image')); ?>">
                                                <p><?php echo e($language->name); ?></p>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>

                </div>
                <div class="flex gap-1.5">
                    <?php $memberHeaderData = \App\Http\Controllers\User\UserController::packages() ?>
                    <div>
                        <div class="relative">
                            <a class="user-header-dropdown-click flex justify-center items-center gap-2 cursor-pointer">
                                <div class="text-white text-16 cursor-pointer font-normal font-Figtree flex text-center items-center justify-center rounded-full h-10 w-10 md:h-11 md:w-11 sign-in-button sign-in mr-2.5">
                                <img class="rounded-full h-9 w-9 md:h-10 md:w-10 cursor-pointer bg-white" src="<?php echo e(Auth::user()->fileUrl()); ?>"
                                alt="Avatar of User">
                                </div>
                                <p class="text-white text-16 font-semibold font-Figtree line-clamp-single hidden md:block">
                                    <?php
                                    if(!empty($memberHeaderData['memberData']) && ($memberHeaderData['isMemberPackage'] === true || auth()->user()->hasCredit('word'))){
                                        echo session()->get('memberPackageData.packUserName');
                                    }else{
                                        echo trimWords(Auth::user()->name);
                                    }
                                    ?>
                                </p>
                            </a>
                            <div
                                class="hidden origin-top-right md:top-14 top-[42px] absolute md:right-0 -right-[46px] mx-auto md:-mt-1 mt-2 w-[210px] border border-color-89 dark:border-color-3A rounded-lg bg-white dark:bg-color-47 z-50 user-header-drop-down dropdown-shadow landing-header-dropdown">
                                <div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($memberHeaderData['memberData']) && ($memberHeaderData['isMemberPackage'] === true || auth()->user()->hasCredit('word'))): ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $memberHeaderData['memberPackages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $memberPackage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <div class="pt-4 pb-2">
                                        <a data-member-package="<?php echo e($memberPackage['id']); ?>" 
                                        class="package-change cursor-pointer flex justify-start items-center gap-1.5 text-14 font-medium px-[18px] font-Figtree
                                        <?php echo e($memberPackage['id'] == @$memberHeaderData['memberCurrentPackage']['packageUser'] ? 'text-[#059669] break-words' : 'text-color-14 dark:text-white'); ?>">
                                            <p class="<?php echo e($memberPackage['id'] == @$memberHeaderData['memberCurrentPackage']['packageUser'] ? 'text-[#059669]' : 'wrap-anywhere'); ?>"> 
                                                <?php echo e($memberPackage['package_name']); ?> 
                                                <?php echo e($memberPackage['id'] == @$memberHeaderData['memberCurrentPackage']['packageUser']?'✓':''); ?>

                                            </p>
                                        </a>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?> 
                                    <div class="pt-2 pb-2 border-t border-color-DF dark:border-color-89">
                                        <a href="<?php echo e(route('user.profile')); ?>" class="flex justify-start items-center gap-1.5 break-words text-14 font-medium text-color-14 dark:text-white font-Figtree px-[18px] hover:bg-color-F6 dark:hover:bg-[#3A3A39]">
                                            <p class="wrap-anywhere"><?php echo e(__('Profile')); ?></p>
                                        </a>
                                    </div>
                                    <div class="pb-2">
                                        <a href="<?php echo e(route('user.package')); ?>" class="flex justify-start items-center gap-1.5 break-words text-14 font-medium text-color-14 dark:text-white font-Figtree px-[18px] hover:bg-color-F6 dark:hover:bg-[#3A3A39]">
                                            <p class="wrap-anywhere"><?php echo e(__('Subscription')); ?></p>
                                        </a>
                                    </div>
                                    <div class="pb-4">
                                        <a href="<?php echo e(route('users.logout')); ?>" class="flex justify-start items-center gap-1.5 break-words text-14 font-medium text-color-14 dark:text-white font-Figtree px-[18px] hover:bg-color-F6 dark:hover:bg-[#3A3A39]">
                                            <p class="wrap-anywhere"><?php echo e(__('Logout')); ?></p>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</header>
<script>
    "use strict";

const USER_REDIRECT_DASHBOARD = "<?php echo e(route('user.dashboard')); ?>";
const MEMBER_SESSION_UPDATE = "<?php echo e(route('user.subscription.memberSessionUpdate')); ?>";

</script>
<?php /**PATH /home/consuadmin/public_html/resources/views/user/includes/header.blade.php ENDPATH**/ ?>