
<?php $__env->startSection('page_title', __('Edit :x', ['x' => __('AI Preferences')])); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="preference-container">
        <div class="card">
            <div class="card-body row" id="preference-container">
                <div class="col-lg-3 col-12 z-index-10 pe-0 ps-0 ps-md-3" aria-labelledby="navbarDropdown">
                    <div class="card card-info shadow-none" id="nav">
                        <div class="card-header pt-4 border-bottom text-nowrap">
                            <h5 id="general-settings"><?php echo e(__('Content Types')); ?></h5>
                        </div>
                        <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                            <li><a class="nav-link text-left tab-name active" id="v-pills-setup-tab" data-bs-toggle="pill"
                                href="#v-pills-setup" role="tab" aria-controls="v-pills-setup"
                                aria-selected="true" data-id="<?php echo e(__('AI Setup')); ?>"><?php echo e(__('AI Setup')); ?></a></li>
                            <li><a class="nav-link text-left tab-name" id="v-pills-bad-word-tab" data-bs-toggle="pill"
                                href="#v-pills-bad-word" role="tab" aria-controls="v-pills--bad-word"
                                aria-selected="true" data-id="<?php echo e(__('Bad Words')); ?>"><?php echo e(__('Bad Words')); ?></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-9 col-12 ps-0">
                    <div class="card card-info shadow-none">
                        <div class="card-header pt-4 border-bottom">
                            <h5><span id="theme-title"><?php echo e(__('Document')); ?></span></h5>
                        </div>
                        <div class="card-body">
                            <form method="post" action="<?php echo e(route('admin.features.preferences.create')); ?>" id="aiSettings">
                                <?php echo csrf_field(); ?>

                                <div class="tab-content p-0 box-shadow-unset" id="topNav-v-pills-tabContent">
                                    
                                    <div class="tab-pane fade active show" id="v-pills-setup" role="tabpanel" aria-labelledby="v-pills-setup-tab">
                                        <div class="row">
                                            <div class="d-flex justify-content-between mt-16p">
                                                <div id="#headingOne">
                                                    <h5 class="text-btn"><?php echo e(__('Ai Key')); ?></h5>
                                                </div>
                                                <div class="mr-3"></div>
                                            </div>
                                            <div class="card-body p-l-15">
                                                <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" id="token">
                                                <div class="form-group row">
                                                    <label class="col-sm-3 control-label text-left"><?php echo e(__('OpenAi Key')); ?></label>
                                                    <div class="col-sm-8">
                                                        <input type="text"
                                                            value="<?php echo e(config('openAI.is_demo') ? 'sk-xxxxxxxxxxxxxxx' : config('aiKeys.OPENAI.API_KEY')); ?>"
                                                            class="form-control inputFieldDesign" name="apiKey[openai]" id="openai_key">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-3 control-label text-left"><?php echo e(__('Stable Diffusion Key')); ?></label>
                                                    <div class="col-sm-8">
                                                        <input type="text"
                                                            value="<?php echo e(config('openAI.is_demo') ? 'sk-xxxxxxxxxxxxxxx' : (config('aiKeys.STABLEDIFFUSION.API_KEY') ? config('aiKeys.STABLEDIFFUSION.API_KEY') : ($openai['stablediffusion'] ?? '' ))); ?>"
                                                            class="form-control inputFieldDesign" name="apiKey[stablediffusion]" id="stable_diffusion_key">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-3 control-label text-left"><?php echo e(__('Google API Key')); ?></label>
                                                    <div class="col-sm-8">
                                                        <input type="text"
                                                            value="<?php echo e(config('openAI.is_demo') ? 'sk-xxxxxxxxxxxxxxx' : (config('aiKeys.GOOGLE.API_KEY') ? config('aiKeys.GOOGLE.API_KEY') : ($openai['google_api'] ?? '' ))); ?>"
                                                            class="form-control inputFieldDesign" name="apiKey[google]" id="googleApi_key">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-3 control-label text-left"><?php echo e(__('Clipdrop API Key')); ?></label>
                                                    <div class="col-sm-8">
                                                        <input type="text"
                                                            value="<?php echo e(config('openAI.is_demo') ? 'sk-xxxxxxxxxxxxxxx' : (config('aiKeys.CLIPDROP.API_KEY') ? config('aiKeys.CLIPDROP.API_KEY') : ($openai['clipdrop_api'] ?? ''))); ?>"
                                                            class="form-control inputFieldDesign" name="apiKey[clipdrop]" id="clipdropApi_key">
                                                    </div>
                                                </div>
                                                <?php
                                                    $addon = \Modules\Addons\Entities\Addon::find('anthropic');
                                                ?>

                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($addon && $addon->isEnabled()): ?>
                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label text-left"><?php echo e(__('Anthropic API Key')); ?></label>
                                                        <div class="col-sm-8">
                                                            <input type="text"
                                                                value="<?php echo e(config('openAI.is_demo') ? 'sk-xxxxxxxxxxxxxxx' : config('aiKeys.ANTHROPIC.API_KEY')); ?>"
                                                                class="form-control inputFieldDesign" name="apiKey[anthropic]" id="anthropicApi_key">
                                                        </div>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                                <?php echo do_action('before_provider_api_key_section_retrived', ''); ?>

                                                <div class="form-group row">
                                                    <label class="col-sm-3 control-label text-left require"><?php echo e(__('Max Length for Short Description')); ?></label>
                                                    <div class="col-sm-8">
                                                        <input type="text"
                                                            value="<?php echo e($openai['short_desc_length'] ?? ''); ?>"
                                                            class="form-control inputFieldDesign positive-int-number" name="short_desc_length" required pattern="^(?:[1-9]|[1-9][0-9]{1,2}|1000)$"
                                                            oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')" data-pattern="<?php echo e(__('Value exceeds the maximum limit of 1000.')); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-3 control-label text-left require"><?php echo e(__('Max Length for Long Description ')); ?></label>
                
                                                    <div class="col-sm-8">
                                                        <input type="text"
                                                            value="<?php echo e($openai['long_desc_length'] ?? ''); ?>"
                                                            class="form-control inputFieldDesign positive-int-number" name="long_desc_length" required  pattern="^(?:[1-9]|[1-9][0-9]{1,2}|1000)$"
                                                            oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')" data-pattern="<?php echo e(__('Value exceeds the maximum limit of 1000.')); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-3 text-left control-label"><?php echo e(__('Word Count method based on')); ?></label>
                                                    <div class="col-sm-8">
                                                        <select class="form-control select2-hide-search inputFieldDesign" name="word_count_method">
                                                            <option value="token" <?php echo e($openai['word_count_method'] == 'token' ? 'selected="selected"' : ''); ?>><?php echo e(__('Token')); ?></option>
                                                            <option value="count_word_function" <?php echo e($openai['word_count_method'] == 'count_word_function' ? 'selected="selected"' : ''); ?>><?php echo e(__('Word Counter')); ?></option>
                                                        </select>
                                                        <div class="py-1" id="note_txt_1">
                                                            <p><span class="badge badge-danger h-100 mt-1"> <?php echo e(__('Note')); ?>!</span> <?php echo __('Token counting is performed in accordance with OpenAI\'s token counting guidelines, as outlined in their official :x. Meanwhile, word counting is based on the conventional method', ['x' => '
                                                            <a href="https://help.openai.com/en/articles/4936856-what-are-tokens-and-how-to-count-them" target="_blank">' . __('documentation') . '</a>']); ?> </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="tab-pane fade" id="v-pills-bad-word" role="tabpanel" aria-labelledby="v-pills-bad-word-tab">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group row">
                                                    <div class="col-12">
                                                        <label for="default-category" class="control-label"><?php echo e(__('Words')); ?></label>
                                                        <div class="col-sm-12">
                                                            <textarea class="form-control" rows="5" name="bad_words"><?php echo e($openai['bad_words'] ?? ''); ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="py-1" id="note_txt_1">
                                                    <div class="d-flex mt-1 mb-3">
                                                        <span class="badge badge-danger h-100 mt-1"> <?php echo e(__('Note')); ?>!</span>
                                                        <ul class="list-unstyled ml-3">
                                                            <li><?php echo e(__('After using each bad word, please differentiate them using a comma (,).')); ?> </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="footer py-0">
                                    <div class="form-group row">
                                        <label for="btn_save" class="col-sm-3 control-label"></label>
                                        <div class="m-auto">
                                            <button type="submit"
                                                class="btn form-submit custom-btn-submit float-right package-submit-button"
                                                id="footer-btn"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('mediamanager::image.modal_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Modules/OpenAI/Resources/assets/js/admin/preference.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/Modules/OpenAI/Resources/views/admin/preference/index.blade.php ENDPATH**/ ?>