<?php
    $component = isset($component) ? $component : null;
?>

<style>
    .brands-template-v1-<?php echo e($component->id); ?> {
        --text-color-light: <?php echo e($component->text_color_light); ?>;
        --text-color-dark: <?php echo e($component->text_color_dark); ?>;

        --bg-color-light: <?php echo e($component->main_bg_color_light); ?>;
        --bg-color-dark: <?php echo e($component->main_bg_color_dark); ?>;
    }

    .brand-bg-<?php echo e($component->id); ?> {
        background-image: url('<?php echo e(isset($component->main_bg_image_light) && !empty($component->main_bg_image_light) ? urlSlashReplace(pathToUrl($component->main_bg_image_light)) : ''); ?>');
        background-repeat: no-repeat, repeat;
        background-size: cover;
    }
    .dark .brand-bg-<?php echo e($component->id); ?> {
        background-image: url('<?php echo e(isset($component->main_bg_image_dark) && !empty($component->main_bg_image_dark) ? urlSlashReplace(pathToUrl($component->main_bg_image_dark)) : ''); ?>');
        background-repeat: no-repeat, repeat;
        background-size: cover;
    }
</style>

<?php
    $textColor = empty($component->text_color_light) && empty($component->text_color_dark) ? 'text-color-14 dark:text-white' : 'text-[var(--text-color-light)] dark:text-[var(--text-color-dark)]';

    $bgColor =  empty($component->main_bg_color_light) && empty($component->main_bg_color_dark) ? '' : 'bg-[var(--bg-color-light)] dark:bg-[var(--bg-color-dark)]';
?>

<?php echo do_action('handle_adsense_output_top',  $component); ?>

<div class="relative py-[75px] brands-template-v1-<?php echo e($component->id); ?> <?php echo e($component->background_type == 'backgroundImage' ? 'brand-bg-' . $component->id : $bgColor); ?>" 
    style="padding:<?php echo e(!empty($component->pt_y) ? $component->pt_y . ' ' . '0' : ''); ?>;">
    
    <p class="font-bold text-center font-RedHat 6xl:text-32 text-28 md:px-10 px-5 <?php echo e($textColor); ?>">
        <?php echo $component->heading; ?>

    </p>
    <p class=" text-center 6xl:text-18 text-16 font-normal mt-4 md:px-10 px-5 font-Figtree <?php echo e($textColor); ?>">
        <?php echo e($component->body); ?>

    </p>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if( isset($component->brand) && count($component->brand) != 0 ): ?>
        <div class="flex flex-wrap justify-center items-center md:gap-10 gap-[26px] mt-[60px] md:px-10 px-0">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $component->brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($brand['light_logo']) && !empty($brand['light_logo'])): ?>
                    <img class="w-[200px] h-[60px] dark:hidden neg-transition-scale" src="<?php echo e(pathToUrl($brand['light_logo'])); ?>" alt="<?php echo e(__('Image')); ?>">
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($brand['dark_logo']) && !empty($brand['dark_logo'])): ?>
                    <img class="w-[200px] h-[60px] hidden dark:block neg-transition-scale" src="<?php echo e(pathToUrl($brand['dark_logo'])); ?>" alt="<?php echo e(__('Image')); ?>">
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

<?php echo do_action('handle_adsense_output_bottom',  $component); ?>
<?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/templates/blocks/brands-template-v1.blade.php ENDPATH**/ ?>