<?php
    $component = isset($component) ? $component : null;
    $allBlogs = \Modules\CMS\Service\Homepage::getBlogsList();
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('Overline')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign crequired" maxlength="70" name="overline"
                        value="<?php echo e($component ? $component->overline : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign crequired" name="heading"
                        value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left ">
                            <dt><?php echo e(__('Blog Button')); ?></dt>
                        </label>
                        <input type="hidden" name="blog_button" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="blog_button"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->blog_button == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Name')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign" maxlength="40"
                                        value="<?php echo e($component ? $component->btn_name : ''); ?>" name="btn_name">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign"
                                        value="<?php echo e($component ? $component->btn_link : ''); ?>" name="btn_link">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light"
                                            value="<?php echo e($component ? $component->btn_text_color_light : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark"
                                            value="<?php echo e($component ? $component->btn_text_color_dark : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('Blog Type')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <select type="text" class="form-control crequired select3 blog_type" name="blog_type">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \Modules\CMS\Service\Homepage::blogsOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e($component && $component->blog_type == $key ? 'selected' : ''); ?>

                                value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>
            </div>
            <div
                class="form-group row cats selectedBlogs <?php echo e($component && $component->blog_type == 'selectedBlogs' ? '' : 'd-none'); ?>">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Blogs')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <select type="text" class="form-control select2 sl_common_bx select_blog" <?php echo e($component && $component->blog_type == 'selectedBlogs' ? 'required' : ''); ?> name="blogs[]" multiple>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && is_array($component->blogs)): ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $component->blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($allBlogs[$selected])): ?>
                                    <Option selected value="<?php echo e($selected); ?>"><?php echo e($allBlogs[$selected]); ?>

                                    </Option>
                                    <?php
                                        unset($allBlogs[$selected]);
                                    ?>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $allBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <Option value="<?php echo e($key); ?>"><?php echo e($value); ?></Option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="form-group row cats latestBlogs <?php echo e(empty($component->blog_type) || $component->blog_type == 'latestBlogs' ? '' : 'd-none'); ?>">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('No. of blogs to show')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <div>
                        <input type="number" min="1" max="30" class="form-control crequired inputFieldDesign blog_limit" name="blog_limit"
                        <?php echo e(empty($component->blog_type) || $component->blog_type == 'latestBlogs' ? 'required' : ''); ?>

                            value="<?php echo e($component ? $component->blog_limit : 10); ?>" data-min="<?php echo e(__('The value must be :x than or equal to :y', ['x' => __('greater'), 'y' => 1])); ?>" data-max="<?php echo e(__('The value must be :x than or equal to :y.', ['x' => __('less'), 'y' => 30])); ?>">
                    </div>
                    <div class="d-flex mt-2">
                        <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                        <small
                            class="mt-1 ltr:ms-2 rtl:me-2 px-2"><?php echo e(__('Total blogs to display should be between 1 to 30. Default is 10')); ?></small>
                    </div>
                </div>
            </div>

            
            <hr>
            <div class="form-group row">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('Newsletter Body')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="newsletter_body"><?php echo e($component ? $component->newsletter_body : ''); ?></textarea>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Newsletter Button')); ?></dt>
                        </label>
                        <input type="hidden" name="newsletter_button" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="newsletter_button"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->newsletter_button == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign" maxlength="25"
                                value="<?php echo e($component ? $component->newsletter_btn_name : ''); ?>" name="newsletter_btn_name">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="newsletter_btn_color_light"
                                            value="<?php echo e($component ? $component->newsletter_btn_color_light : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="newsletter_btn_color_dark"
                                            value="<?php echo e($component ? $component->newsletter_btn_color_dark : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="newsletter_btn_text_color_light"
                                            value="<?php echo e($component ? $component->newsletter_btn_text_color_light : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="newsletter_btn_text_color_dark"
                                            value="<?php echo e($component ? $component->newsletter_btn_text_color_dark : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['padding-vertical']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>
            
            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>

<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/blogs-template-v1.blade.php ENDPATH**/ ?>