<?php
    $component = isset($component) ? $component : null;
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" novalidate data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Overline')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign crequired" maxlength="70" name="overline"
                       value="<?php echo e($component ? $component->overline : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign crequired" name="heading"
                       value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>

            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Body')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="body" required> <?php echo e($component ? trim($component->body) : ''); ?></textarea>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('First Block')); ?></dt>
                        </label>
                        <input type="hidden" name="first_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="first_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->first_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light"
                                        value="<?php echo e($component ? $component->bg_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark"
                                        value="<?php echo e($component ? $component->bg_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="first_block_text_color_light"
                                        value="<?php echo e($component ? $component->first_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="first_block_text_color_dark"
                                        value="<?php echo e($component ? $component->first_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width"
                                            value="<?php echo e($component && $component->border_width ? $component->border_width : ''); ?>" placeholder="1"
                                            class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="form-group row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style"
                                        value="<?php echo e($component && $component->border_style ? $component->border_style : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="form-group row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color" data-control="hue"
                                        value="<?php echo e($component && $component->border_color ? $component->border_color : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Heading')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign crequired" name="block1_heading"
                               value="<?php echo e($component ? $component->block1_heading : ''); ?>">
                        </div>
                    </div>    
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('First Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block1_body" required> <?php echo e($component ? trim($component->block1_body) : ''); ?></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Second Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block1_second_body" required> <?php echo e($component ? trim($component->block1_second_body) : ''); ?></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="image_light_mode" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="image_light_mode"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image_light_mode): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->image_light_mode)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="image_light_mode"
                                                        value="<?php echo e($component->image_light_mode); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="image_dark_mode" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="image_dark_mode"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image_dark_mode): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->image_dark_mode)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="image_dark_mode"
                                                        value="<?php echo e($component->image_dark_mode); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Floating Image (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="floating_image_light_mode" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="floating_image_light_mode"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->floating_image_light_mode): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->floating_image_light_mode)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="floating_image_light_mode"
                                                        value="<?php echo e($component->floating_image_light_mode); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Floating Image (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="floating_image_dark_mode" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="floating_image_dark_mode"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->floating_image_dark_mode): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->floating_image_dark_mode)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="floating_image_dark_mode"
                                                        value="<?php echo e($component->floating_image_dark_mode); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign" maxlength="40"
                                                value="<?php echo e($component ? $component->block1_btn_name : ''); ?>" name="block1_btn_name">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign"
                                                value="<?php echo e($component ? $component->block1_btn_link : ''); ?>" name="block1_btn_link">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Light Mode)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="block1_btn_text_color_light"
                                                    value="<?php echo e($component ? $component->block1_btn_text_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Text Color (Dark Mode)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="block1_btn_text_color_dark"
                                                    value="<?php echo e($component ? $component->block1_btn_text_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Second Block')); ?></dt>
                        </label>
                        <input type="hidden" name="second_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="second_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->second_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light2"
                                        value="<?php echo e($component ? $component->bg_color_light2 : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark2"
                                        value="<?php echo e($component ? $component->bg_color_dark2 : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="second_block_text_color_light"
                                        value="<?php echo e($component ? $component->second_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="second_block_text_color_dark"
                                        value="<?php echo e($component ? $component->second_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width2"
                                            value="<?php echo e($component && $component->border_width2 ? $component->border_width2 : ''); ?>" placeholder="1"
                                            class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="form-group row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style2"
                                        value="<?php echo e($component && $component->border_style2 ? $component->border_style2 : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="form-group row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color2" data-control="hue"
                                        value="<?php echo e($component && $component->border_color2 ? $component->border_color2 : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Heading')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign crequired" name="block2_heading"
                               value="<?php echo e($component ? $component->block2_heading : ''); ?>">
                        </div>
                    </div>    
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block2_body" required> <?php echo e($component ? trim($component->block2_body) : ''); ?></textarea>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="image_light_mode2" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="image_light_mode2"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image_light_mode2): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->image_light_mode2)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="image_light_mode2"
                                                        value="<?php echo e($component->image_light_mode2); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Third Block')); ?></dt>
                        </label>
                        <input type="hidden" name="third_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="third_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->third_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_light3"
                                        value="<?php echo e($component ? $component->bg_color_light3 : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Background Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="bg_color_dark3"
                                        value="<?php echo e($component ? $component->bg_color_dark3 : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="third_block_text_color_light"
                                        value="<?php echo e($component ? $component->third_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="third_block_text_color_dark"
                                        value="<?php echo e($component ? $component->third_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4 col-md-4">
                            <div class="row">
                                <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                <div class="col-md-12">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                        </div>
                                        <input type="number" name="border_width3"
                                            value="<?php echo e($component && $component->border_width3 ? $component->border_width3 : ''); ?>" placeholder="1"
                                            class="form-control inputFieldDesign">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="form-group row">
                                <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_style3"
                                        value="<?php echo e($component && $component->border_style3 ? $component->border_style3 : ''); ?>" placeholder="Solid"
                                        class="form-control inputFieldDesign">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4">
                            <div class="form-group row">
                                <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                <div class="col-md-12">
                                    <input type="text" name="border_color3" data-control="hue"
                                        value="<?php echo e($component && $component->border_color3 ? $component->border_color3 : ''); ?>"
                                        class="form-control demo layout-primary-color inputFieldDesign">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="accordion step-accordion <?php echo e($accordId = uniqid('accord_')); ?>" id="accordionExample">
                                <?php
                                    $steps = $component && is_array($component->step) ? $component->step : [];
                                    $totalSteps = count($steps);
                                ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        
                                    <?php $step = miniCollection($step); ?>
        
                                    <div class="card cta-card mb-3">
                                        <div class="card-header p-2" id="headingOne">
                                            <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                                data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                                aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                                <div><?php echo e(__('Step')); ?></div>
                                                <span class="b-icon">
                                                    <i class="feather icon-chevron-down collapse-status"></i>
                                                    <span class="accordion-action-group">
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($loop->last): ?>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($totalSteps > 1): ?>
                                                                <span class="accordion-row-action remove-row-btn"
                                                                    data-parent="<?php echo e($accordId); ?>"
                                                                    data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                        class="feather icon-minus"></i></span>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            <span class="accordion-row-action add-row-btn"
                                                                data-parent="<?php echo e($accordId); ?>"
                                                                data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                    class="feather icon-plus"></i></span>
                                                        <?php else: ?>
                                                            <span class="accordion-row-action remove-row-btn"
                                                                data-index="<?php echo e($loop->index + 1); ?>"
                                                                data-parent="<?php echo e($accordId); ?>"><i
                                                                    class="feather icon-minus"></i></span>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </span>
                                                </span>
                                            </div>
                                        </div>
                                        <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                            aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                            <div class="form-group row">
                                                <div class="col-md-12">
                                                    <div class="form-group row">
                                                        <label class="col-sm-12 control-label"><?php echo e(__('Title')); ?></label>
                                                        <div class="col-sm-12">
                                                            <input type="text" class="form-control inputFieldDesign"
                                                                value="<?php echo $step['title']; ?>" name="step[<?php echo e($loop->index); ?>][title]">
        
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="col-md-12">
                                                    <div class="form-group row">
                                                        <label class="col-sm-12 control-label"><?php echo e(__('Description')); ?></label>
                                                        <div class="col-sm-12">
                                                            <input type="text" class="form-control inputFieldDesign"
                                                                value="<?php echo $step['description']; ?>" name="step[<?php echo e($loop->index); ?>][description]">
        
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="card cta-card mb-3">
                                        <div class="card-header p-2" id="headingOne">
                                            <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                                data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                                aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                                <div><?php echo e(__('Step')); ?></div>
                                                <span class="b-icon">
                                                    <i class="feather icon-chevron-down collapse-status"></i>
                                                    <span class="accordion-action-group">
                                                        <span class="accordion-row-action add-row-btn"
                                                            data-parent="<?php echo e($accordId); ?>" data-index="1"><i
                                                                class="feather icon-plus"></i></span>
                                                    </span>
                                                </span>
                                            </div>
                                        </div>
                                        <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                            aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                            <div class="form-group row">
                                                <div class="col-md-12">
                                                    <div class="form-group row">
                                                        <div class="col-md-12">
                                                            <div class="form-group row">
                                                                <label class="col-sm-12 control-label"><?php echo e(__('Title')); ?></label>
                                                                <div class="col-sm-12">
                                                                    <input type="text" class="form-control inputFieldDesign"
                                                                        name="step[0][title]">
                
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <div class="col-md-12">
                                                            <div class="form-group row">
                                                                <label class="col-sm-12 control-label"><?php echo e(__('Description')); ?></label>
                                                                <div class="col-sm-12">
                                                                    <input type="text" class="form-control inputFieldDesign"
                                                                        name="step[0][description]">
                
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php $rand = uniqid(); ?>
                            <div class="form-group row form-parent parent-class">
                                <label class="col-sm-12 control-label"><?php echo e(__('Image (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div class="custom-file media-manager" data-name="image_light_mode3" data-val="single"
                                        id="image-status">
                                        <input class="custom-file-input form-control d-none inputFieldDesign" name="image_light_mode3"
                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                    </div>
                                    <div class="preview-image">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image_light_mode3): ?>
                                            <div class="d-flex flex-wrap mt-2">
                                                <div
                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                    <div
                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                    <img class="upl-img" class="p-1"
                                                        src="<?php echo e(pathToUrl($component->image_light_mode3)); ?>"
                                                        alt="<?php echo e(__('Image')); ?>">
                                                    <input type="hidden" name="image_light_mode3"
                                                        value="<?php echo e($component->image_light_mode3); ?>">
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>

            <hr>
            
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Forth Block')); ?></dt>
                        </label>
                        <input type="hidden" name="forth_block" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="forth_block"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->forth_block == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="accordion content-accordion <?php echo e($accordId = uniqid('accord_')); ?>" id="accordionExample">
                                <?php
                                    $contents = $component && is_array($component->content) ? $component->content : [];
                                    $totalContents = count($contents);
                                ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        
                                    <?php $content = miniCollection($content); ?>
        
                                    <div class="card cta-card mb-3">
                                        <div class="card-header p-2" id="headingOne">
                                            <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                                data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                                aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                                <div><?php echo e(__('Content')); ?></div>
                                                <span class="b-icon">
                                                    <i class="feather icon-chevron-down collapse-status"></i>
                                                    <span class="accordion-action-group">
                                                        <?php if($loop->last): ?>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($totalContents > 1): ?>
                                                                <span class="accordion-row-action remove-row-btn"
                                                                    data-parent="<?php echo e($accordId); ?>"
                                                                    data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                        class="feather icon-minus"></i></span>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                            <span class="accordion-row-action add-row-btn"
                                                                data-parent="<?php echo e($accordId); ?>"
                                                                data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                    class="feather icon-plus"></i></span>
                                                        <?php else: ?>
                                                            <span class="accordion-row-action remove-row-btn"
                                                                data-index="<?php echo e($loop->index + 1); ?>"
                                                                data-parent="<?php echo e($accordId); ?>"><i
                                                                    class="feather icon-minus"></i></span>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </span>
                                                </span>
                                            </div>
                                        </div>
                                        <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                            aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                            <div class="form-group row">
                                                <label class="col-sm-12 control-label"><?php echo e(__('Icon')); ?></label>
                                                <?php $rand = uniqid(); ?>
                                                <div class="col-md-12">
                                                    <div class="custom-file media-manager"
                                                        data-name="content[<?php echo e($loop->index); ?>][icon_light]"
                                                        data-val="single" id="image-status">
                                                        <input class="custom-file-input form-control d-none"
                                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                                    </div>

                                                    <div class="d-flex mt-2">
                                                        <span class="badge badge-danger h-100 mt-1"><?php echo e(__('Note')); ?>!</span>
                                                        <small
                                                            class="mt-1 ltr:ms-2 rtl:me-2 ps-1"><?php echo e(__('For better resolution and superior quality, it is recommended to use SVG format.')); ?></small>
                                                    </div>
                                                    
                                                    <div class="preview-image">
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($content['icon_light']): ?>
                                                            <div class="d-flex flex-wrap mt-2">
                                                                <div
                                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                                    <div
                                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                                        <i class="fa fa-times"></i>
                                                                    </div>
                                                                    <img class="upl-img" class="p-1"
                                                                        src="<?php echo e(pathToUrl($content['icon_light'])); ?>"
                                                                        alt="<?php echo e(__('Image')); ?>">
                                                                    <input type="hidden"
                                                                        name="content[<?php echo e($loop->index); ?>][icon_light]"
                                                                        id="validatedCustomFile"
                                                                        value="<?php echo e($content['icon_light']); ?>">
                                                                </div>
                                                            </div>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="col-md-12">
                                                    <div class="form-group row">
                                                        <label class="col-sm-12 control-label"><?php echo e(__('Title')); ?></label>
                                                        <div class="col-sm-12">
                                                            <input type="text" class="form-control inputFieldDesign"
                                                                value="<?php echo $content['title']; ?>" name="content[<?php echo e($loop->index); ?>][title]">
        
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="card cta-card mb-3">
                                        <div class="card-header p-2" id="headingOne">
                                            <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                                data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                                aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                                <div><?php echo e(__('Content')); ?></div>
                                                <span class="b-icon">
                                                    <i class="feather icon-chevron-down collapse-status"></i>
                                                    <span class="accordion-action-group">
                                                        <span class="accordion-row-action add-row-btn"
                                                            data-parent="<?php echo e($accordId); ?>" data-index="1"><i
                                                                class="feather icon-plus"></i></span>
                                                    </span>
                                                </span>
                                            </div>
                                        </div>
                                        
                                        <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                            aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                            <div class="form-group row">
                                                <div class="col-md-12">
                                                    <div class="form-group row">
                                                        <label class="col-sm-12 control-label"><?php echo e(__('Icon')); ?></label>
        
                                                        <?php $rand = uniqid(); ?>
                                                        <div class="col-md-12">
                                                            <div class="custom-file media-manager"
                                                                data-name="content[0][icon_light]" data-val="single"
                                                                id="image-status">
                                                                <input class="custom-file-input form-control d-none"
                                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                                            </div>
                                                            <div class="preview-image"></div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <div class="col-md-12">
                                                            <div class="form-group row">
                                                                <label class="col-sm-12 control-label"><?php echo e(__('Title')); ?></label>
                                                                <div class="col-sm-12">
                                                                    <input type="text" class="form-control inputFieldDesign"
                                                                        name="content[0][title]">
                
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Heading')); ?></label>
                        <div class="col-sm-12">
                            <input type="text" class="form-control inputFieldDesign crequired" name="block4_heading"
                               value="<?php echo e($component ? $component->block4_heading : ''); ?>">
                        </div>
                    </div>    
                    <div class="row">
                        <label class="col-sm-12 control-label"><?php echo e(__('Body')); ?></label>
                        <div class="col-sm-12">
                            <textarea class="form-control crequired" name="block4_body" required> <?php echo e($component ? trim($component->block4_body) : ''); ?></textarea>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="forth_block_text_color_light"
                                        value="<?php echo e($component ? $component->forth_block_text_color_light : ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text"
                                        class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="forth_block_text_color_dark"
                                        value="<?php echo e($component ? $component->forth_block_text_color_dark : ''); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign" maxlength="40"
                                                value="<?php echo e($component ? $component->btn_name : ''); ?>" name="btn_name">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                        <div class="col-sm-12">
                                            <input type="text" class="form-control inputFieldDesign"
                                                value="<?php echo e($component ? $component->btn_link : ''); ?>" name="btn_link">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_light"
                                                    value="<?php echo e($component ? $component->btn_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Button Color (dark)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_dark"
                                                    value="<?php echo e($component ? $component->btn_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light"
                                                    value="<?php echo e($component ? $component->btn_text_color_light : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3 col-md-3">
                                    <div class="form-group">
                                        <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                        <div class="col-sm-12">
                                            <div>
                                                <input type="text"
                                                    class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark"
                                                    value="<?php echo e($component ? $component->btn_text_color_dark : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4 col-md-4">
                                    <div class="row">
                                        <label class="col-md-12"><?php echo e(__('Border Width')); ?></label>
                                        <div class="col-md-12">
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text rounded-0 rounded-start h-40" id="basic-addon1">PX</span>
                                                </div>
                                                <input type="number" name="border_width4"
                                                    value="<?php echo e($component && $component->border_width4 ? $component->border_width4 : ''); ?>" placeholder="1"
                                                    class="form-control inputFieldDesign">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="row">
                                        <label class="col-md-12"><?php echo e(__('Border Style')); ?></label>
                                        <div class="col-md-12">
                                            <input type="text" name="border_style4"
                                                value="<?php echo e($component && $component->border_style4 ? $component->border_style4 : ''); ?>" placeholder="Solid"
                                                class="form-control inputFieldDesign">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="row">
                                        <label class="col-md-12"><?php echo e(__('Border Color')); ?></label>
                                        <div class="col-md-12">
                                            <input type="text" name="border_color4" data-control="hue"
                                                value="<?php echo e($component && $component->border_color4 ? $component->border_color4 : ''); ?>"
                                                class="form-control demo layout-primary-color inputFieldDesign">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['padding-vertical']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>

            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>


<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/ready-made-template-v1.blade.php ENDPATH**/ ?>