<?php

namespace Modules\OpenAI\Transformers\Api\v2;

use Illuminate\Http\Resources\Json\JsonResource;

class UserAccessResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        $user = auth()->user();

        if (empty($this->resource) || $user->role()->type == 'admin') {
            return [
                "hide_template" => false,
                "hide_image" => false,
                "hide_code" => false,
                "hide_speech_to_text" => false,
                "hide_text_to_speech" => false,
                "hide_long_article" => false,
                "hide_chat" => false,
                "hide_plagiarism" => false,
                "hide_aichatbot" => false,
                "hide_video" => false,
                "hide_text_to_video" => false,
                "hide_ai_persona" => false,
                "hide_ai_avatar" => false,
                "hide_ai_productshot" => false,
                "theme" => $user->theme_preference ?? 'light',
            ];
        }

        foreach ($this->resource as $key => $value) {
            $data[$key] = $value === "1" ? true : false;
        }

        $data['theme'] = $user->theme_preference ?? 'light';

        return $data;
    }
}
