<?php

namespace Modules\OpenAI\AiProviders\OpenAi\Responses\Video;

use Exception;
use Modules\OpenAI\Contracts\Responses\Video\VideoResponseContract;

class VideoResponse implements VideoResponseContract
{
    public array $response;
    public string $videoId = '';

    public function __construct(array $aiResponse)
    {
        $this->response = $aiResponse;
        $this->process();
    }

    public function process(): string
    {
        if ($this->response['code'] === 401) {
            $this->handleException(__("There's an issue with the :x API key. Kindly reach out to the administration for assistance.", ['x' => 'OpenAI']));
        }

        if (!in_array($this->response['code'], [200, 202], true)) {
            $message = data_get($this->response, 'body.error.message') ?: __('Something went wrong, please try again.');
            $this->handleException($message);
        }

        return $this->video();
    }

    public function video(): string
    {
        return $this->videoId = data_get($this->response, 'body.id', '');
    }

    public function response(): mixed
    {
        return data_get($this->response, 'body', []);
    }

    public function handleException(string $message): Exception
    {
        throw new Exception($message);
    }
}

