<?php

namespace Modules\OpenAI\AiProviders\OpenAi\Responses\Video;

use Exception;
use Modules\OpenAI\Contracts\Responses\Video\FetchVideoResponseContract;
use Modules\OpenAI\AiProviders\OpenAi\Responses\Traits\FetchVideoTrait;

class FetchVideoResponse implements FetchVideoResponseContract
{
    use FetchVideoTrait;

    public array $response;
    public array $videos = [];

    public function __construct(array $aiResponse)
    {
        $this->response = $aiResponse;
        $this->process();
    }

    public function process(): mixed
    {
        try {
            return $this->processVideoFetch();
        } catch (\Throwable $e) {
            $this->handleException($e->getMessage());
        }
    }

    public function videos(): array
    {
        return $this->videos;
    }

    /**
     * Add video content to the videos array (implementation of abstract method)
     *
     * @param mixed $content
     * @return void
     */
    protected function addVideoContent(mixed $content): void
    {
        $this->videos[] = $content;
    }

    /**
     * Get the video content collection (implementation of abstract method)
     *
     * @return array
     */
    protected function getVideoContent(): array
    {
        return $this->videos;
    }

    /**
     * Get the response content.
     *
     * @return mixed
     */
    public function response(): mixed
    {
        return data_get($this->response, 'body', []);
    }

    /**
     * Handle exceptions.
     *
     * @param string $message
     * @return Exception
     */
    public function handleException(string $message): Exception
    {
        throw new Exception($message);
    }
}

