<?php

namespace Modules\OpenAI\AiProviders\OpenAi\Responses\Video;

use Exception;
use Modules\OpenAI\Contracts\Responses\Video\CheckVideoResponseContact;

class CheckVideoResponse implements CheckVideoResponseContact
{
    public array $response;
    public string $status = 'queued';
    public array $urls = [];

    public function __construct(array $aiResponse)
    {
        $this->response = $aiResponse;
        $this->process();
    }

    public function process(): string
    {
        if ($this->response['code'] === 404) {
            $this->handleException(__('Video not found.'));
        }

        if (!in_array($this->response['code'], [200, 202], true)) {
            $message = data_get($this->response, 'body.error.message') ?: __('Something went wrong, please try again.');
            $this->handleException($message);
        }

        return $this->status();
    }

    public function status(): string
    {
        $remoteStatus = data_get($this->response, 'body.status');

        return $this->status = match ($remoteStatus) {
            'queued' => 'queued',
            'running', 'in_progress' => 'running',
            'succeeded', 'completed' => 'succeeded',
            'failed' => 'failed',
            'canceled', 'cancelled' => 'canceled',
            default => 'queued',
        };
    }

    public function urls(): array
    {
        $output = data_get($this->response, 'body.output', []);
        
        return $this->urls = array_filter(
            array_column($output, 'url'),
            fn($url) => !empty($url)
        );
    }

    public function response(): mixed
    {
        return data_get($this->response, 'body', []);
    }

    public function handleException(string $message): Exception
    {
        throw new Exception($message);
    }
}

