<?php

namespace Modules\OpenAI\AiProviders\OpenAi\Responses\TextToVideo;

use Exception;
use Modules\OpenAI\Contracts\Responses\TextToVideo\TextToVideoResponseContract;

class TextToVideoResponse implements TextToVideoResponseContract
{
    public array $response;
    public mixed $video = null;

    public function __construct(array $aiResponse)
    {
        $this->response = $aiResponse;
        $this->process();
    }

    public function process(): mixed
    {
        if ($this->response['code'] === 401) {
            $this->handleException(__("There's an issue with the :x API key. Kindly reach out to the administration for assistance.", ['x' => 'OpenAI']));
        }

        if (!in_array($this->response['code'], [200, 202], true)) {
            $message = data_get($this->response, 'body.error.message') ?: __('Something went wrong, please try again.');
            $this->handleException($message);
        }

        return $this->video();
    }

    public function video(): mixed
    {
        return $this->video ??= data_get($this->response, 'body.id');
    }

    public function response(): mixed
    {
        return $this->response['body'] ?? [];
    }

    public function handleException(string $message): Exception
    {
        throw new Exception($message);
    }
}

