<?php

namespace Modules\OpenAI\AiProviders\Clipdrop\Traits;

trait ClipdropApiTrait
{
    private $baseUrl = 'https://clipdrop-api.co';
    private $version = 'v1';
    
    /**
     * Get the Clipdrop API key
     *
     * @return string
     */
    public function aiKey()
    {
        return apiKey('clipdrop');
    }

    /**
     * Get the url of the api endpoint based on the service
     *
     * @param string $service
     * @return string
     */
    public function url(string $service): string
    {
        if ($service == 'reimagine') {
            return $this->baseUrl . '/' . $service .'/'  . $this->version . '/' . $service; 
        }
        return $this->baseUrl . '/' . $service .'/'  . $this->version;
    }

    /**
     * Get the image generated by the ai
     *
     * @return array The response from the api
     */
    public function images()
    {
        $postField = $this->getPostField();

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->url($this->processedData['service']),
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYHOST => config('openAI.ssl_verify_host'),
            CURLOPT_SSL_VERIFYPEER => config('openAI.ssl_verify_peer'),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            
            CURLOPT_POSTFIELDS => $postField,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: " . "multipart/form-data",
                "x-api-key: " . $this->aiKey()
            ),
        ));

        // NOTE:: api key need to change
        
        $image = curl_exec($curl);

         // Get message according to the api response code
        $curlStatusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
       
        return [
            'code' => $curlStatusCode,
            'body' => $image, 
        ];
        
    }

    /**
     * Generate the post field based on the service.
     * 
     * @return array
     */
    public function getPostField(): array
    {
        return match ($this->processedData['service']) {
            'reimagine', 'remove-text', 'remove-background' => [
                'image_file' => $this->processedData['image_file']
            ],
            'replace-background' => [
                'prompt' => $this->processedData['prompt'],
                'image_file' => $this->processedData['image_file']
            ],
            default => [
                'prompt' => $this->processedData['prompt']
            ],
        };
    }
}
