"use strict";$(document).ready((function(){let $segmentsDropdown,$segmentsContainer,$segmentsSearch,$segmentsLoader,$segmentsButton,$segmentsHiddenInput,$segmentsDisplay,selectedSegments=[],searchTimeout,isLoading=!1,currentXhr=null,currentPage=1,hasMorePages=!0,baseUrl="";function init(){$segmentsDropdown=$("#segments-dropdown"),$segmentsContainer=$("#segments-container"),$segmentsSearch=$("#segments-search"),$segmentsLoader=$("#segments-loader"),$segmentsButton=$("#segments-button"),$segmentsHiddenInput=$("#segments-hidden-input"),$segmentsDisplay=$("#segments-display"),0!==$segmentsDropdown.length&&0!==$segmentsContainer.length&&(baseUrl=$segmentsDropdown.attr("data-base-url")||'{{ route("user.marketing-bot.segments.dropdown") }}',loadSegments(!0),setupEventListeners())}function setupEventListeners(){$segmentsDropdown.on("click",(function(e){e.stopPropagation()})),$segmentsSearch.on("click",(function(e){e.stopPropagation()})),$segmentsContainer.on("click",(function(e){e.stopPropagation()})),$segmentsDropdown.on("click","*",(function(e){e.stopPropagation()})),$segmentsSearch.on("input",(function(e){clearTimeout(searchTimeout);const searchTerm=$(this).val().trim();$segmentsLoader.length>0&&(searchTerm?$segmentsLoader.removeClass("hidden"):$segmentsLoader.addClass("hidden")),searchTimeout=setTimeout((function(){loadSegments(!0,searchTerm)}),300)})),$segmentsContainer.on("scroll",(function(){if(isLoading||!hasMorePages)return;const $this=$(this),scrollTop=$this.scrollTop(),scrollHeight=$this[0].scrollHeight,clientHeight=$this.height();scrollTop+clientHeight>=.8*scrollHeight&&loadSegments(!1)}))}function loadSegments(reset=!1,searchTerm=""){if(isLoading)return;currentXhr&&4!==currentXhr.readyState&&(currentXhr.abort(),currentXhr=null),isLoading=!0,reset&&(currentPage=1,hasMorePages=!0);let url=baseUrl;const params=new URLSearchParams;params.append("page",currentPage),searchTerm&&params.append("search",searchTerm),params.toString()&&(url+="?"+params.toString()),currentXhr=$.ajax({url:url,type:"GET",dataType:"json",headers:{"X-Requested-With":"XMLHttpRequest"},beforeSend:function(xhr){currentXhr=xhr},success:function(data){if(!currentXhr||"abort"!==currentXhr.statusText)if(data.success&&data.segments){if(reset&&$segmentsContainer.html(""),0===data.segments.length&&reset)return $segmentsContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <svg class="mx-auto h-12 w-12 text-color-89 dark:text-gray-500 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">\n                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>\n                                </svg>\n                                <p class="text-sm text-color-89 dark:text-gray-400">${jsLang("No segments found")}</p>\n                                <p class="text-xs text-color-89 dark:text-gray-500 mt-1">${jsLang("Try adjusting your search terms")}</p>\n                            </div>\n                        `),currentPage=data.current_page,void(hasMorePages=data.has_more_pages);data.segments.forEach((function(segment){const isSelected=selectedSegments.includes(segment.id),$segmentItem=$(`\n                            <div class="px-4 py-2.5 rounded-lg text-sm text-gray-700 dark:text-gray-200 hover:bg-color-F6 dark:hover:bg-color-3A cursor-pointer flex items-center gap-3 transition-colors duration-150"\n                                data-id="${segment.id}"\n                                data-name="${escapeHtml(segment.name)}">\n                                <div class="relative flex items-center">\n                                    <input type="checkbox"\n                                           class="segment-checkbox w-4 h-4 rounded border-color-DF dark:border-color-47 text-blue-600 focus:ring-2 focus:ring-blue-500 dark:focus:ring-blue-400 focus:ring-offset-0 cursor-pointer transition-all duration-150"\n                                           value="${segment.id}"\n                                           ${isSelected?"checked":""}>\n                                </div>\n                                <span class="flex-1 font-medium">${escapeHtml(segment.name)}</span>\n                            </div>\n                        `),$checkbox=$segmentItem.find(".segment-checkbox");$checkbox.on("change",(function(){const segmentId=$(this).val(),segmentName=$(this).closest("[data-name]").attr("data-name");if($(this).is(":checked"))selectedSegments.includes(segmentId)||selectedSegments.push(segmentId);else{const index=selectedSegments.indexOf(segmentId);index>-1&&selectedSegments.splice(index,1)}updateSelectedDisplay()})),$checkbox.on("click",(function(e){e.stopPropagation()})),$segmentItem.on("click",(function(e){if($(e.target).is('input[type="checkbox"]'))return;e.preventDefault(),e.stopPropagation();const isChecked=$checkbox.is(":checked");$checkbox.prop("checked",!isChecked).trigger("change")})),$segmentsContainer.append($segmentItem)})),currentPage=data.current_page,hasMorePages=data.has_more_pages}else reset&&$segmentsContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <p class="text-sm text-red-500">${jsLang("Failed to load segments")}</p>\n                            </div>\n                        `)},error:function(xhr,status,error){"abort"!==status&&(console.error("Error loading segments:",error),reset&&$segmentsContainer.html('\n                        <div class="px-4 py-8 text-center">\n                            <p class="text-sm text-red-500">Failed to load segments</p>\n                        </div>\n                    '))},complete:function(){isLoading=!1,currentXhr=null,$segmentsLoader.length>0&&$segmentsLoader.addClass("hidden")}})}function updateSelectedDisplay(){if($segmentsHiddenInput.length>0&&$segmentsHiddenInput.val(selectedSegments.join(",")),$segmentsDisplay.length>0)if(0===selectedSegments.length)$segmentsDisplay.text(jsLang("Select Segment"));else if(1===selectedSegments.length){const $selectedItem=$segmentsContainer.find(`[data-id="${selectedSegments[0]}"]`),segmentName=$selectedItem.attr("data-name")||jsLang("Segment");$segmentsDisplay.text(segmentName)}else $segmentsDisplay.text(`${selectedSegments.length} ${jsLang("segments selected")}`)}function escapeHtml(unsafe){if(null==unsafe)return"";const str=String(unsafe);return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}init()}));