<?php

namespace Modules\DatabaseBackup\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\MenuBuilder\Http\Models\MenuItems;

class MenuItemsTableSeeder extends Seeder
{
    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {

        $barCodeId = addMenuItem('admin', 'Tools', [
            'icon' => 'fas fa-cogs',
            'sort' => 50,
        ]);

        addMenuItem('admin', 'Database Backup', [
            'label' => 'Database Backup',
            'link' => 'manual-backup-list',
            'params' => '{"permission":"Modules\\\\DatabaseBackup\\\\Http\\\\Controllers\\\\DatabaseBackupController@list", "route_name":["database.manual.backup.list","dropbox_setting.create","google_drive_setting.create","database.automated.backup"]}',
            'sort' => 63,
            'parent' => $barCodeId,
        ]);
    }
}
